(function () {
    var _eventManager = _$createEventManager(
        function getEventObject(type, attach, obj, ignoreCase) {
            function _eventTypeToObject(type, attach) {
                if (attach) return Event;
                
                switch (type) {
                    case 'close': return CloseEvent;
                    case 'error': return ErrorEvent;
                    case 'loadend': return ProgressEvent;
                    case 'message': return MessageEvent;
                    case 'progress': return ProgressEvent;
                    case 'upgradeneeded': return IDBVersionChangeEvent;
                }
                return Event;
            }
            var e = _eventTypeToObject(type, attach);
            var eventObject = Object.create(e);
            eventObject.target = obj;
            eventObject.currentTarget = obj;
            eventObject.type = type;
            if (eventObject.relatedTarget)
                eventObject.relatedTarget = obj;
            return eventObject;
        });
    var _events = _eventManager.createEventProperties;

    
    var Blob = {};
    var BlobCtor = function() { return Object.create(Blob); };
    var Console = {};
    var DOMError = {};
    var DOMException = {};
    var DOMStringList = {};
    var Event = {};
    var EventCtor = function(type, eventInitDict) { 
        /// <signature>
        /// <param name='type' type='String'/>
        /// <param name='eventInitDict' type='EventInit' optional='true' />
        /// </signature>
        return Object.create(Event);
    };
    var EventTarget = {};
    var FileList = {};
    var IDBCursor = {};
    var IDBFactory = {};
    var IDBIndex = {};
    var IDBKeyRange = {};
    var IDBObjectStore = {};
    var ImageData = {};
    var MSApp = {};
    var MSBlobBuilder = {};
    var MSBlobBuilderCtor = function() { return Object.create(MSBlobBuilder); };
    var MSStream = {};
    var MessageChannel = {};
    var MessageChannelCtor = function() { return Object.create(MessageChannel); };
    var EventListener = {};
    var AbstractWorker = {};
    var MSBaseReader = {};
    var NavigatorID = {};
    var NavigatorOnLine = {};
    var WindowBase64 = {};
    var WindowConsole = {};
    var XMLHttpRequestEventTarget = {};
    var FileReaderSync = {};
    var FileReaderSyncCtor = function() { return Object.create(FileReaderSync); };
    var WorkerLocation = {};
    var DedicatedWorkerGlobalScope = {};
    var CloseEvent = _$inherit(Event);
    var ErrorEvent = _$inherit(Event);
    var File = _$inherit(Blob);
    var FileReader = _$inherit(EventTarget);
    var FileReaderCtor = function() { return Object.create(FileReader); };
    var IDBCursorWithValue = _$inherit(IDBCursor);
    var IDBDatabase = _$inherit(EventTarget);
    var IDBRequest = _$inherit(EventTarget);
    var IDBTransaction = _$inherit(EventTarget);
    var IDBVersionChangeEvent = _$inherit(Event);
    var MSStreamReader = _$inherit(EventTarget);
    var MSStreamReaderCtor = function() { return Object.create(MSStreamReader); };
    var MessageEvent = _$inherit(Event);
    var MessagePort = _$inherit(EventTarget);
    var ProgressEvent = _$inherit(Event);
    var WebSocket = _$inherit(EventTarget);
    var WebSocketCtor = function(url, protocols) { 
        /// <signature>
        /// <param name='url' type='String'/>
        /// <param name='protocols' type='String' optional='true' />
        /// </signature>
        /// <signature>
        /// <param name='url' type='String'/>
        /// <param name='protocols' type='Object' optional='true' />
        /// </signature>
        return Object.create(WebSocket);
    };
    var Worker = _$inherit(EventTarget);
    var WorkerCtor = function(stringUrl) { 
        /// <signature>
        /// <param name='stringUrl' type='String'/>
        /// </signature>
        return Object.create(Worker);
    };
    var XMLHttpRequest = _$inherit(EventTarget);
    var XMLHttpRequestCtor = function() { return Object.create(XMLHttpRequest); };
    var WorkerNavigator = {};
    var WorkerUtils = {};
    var IDBOpenDBRequest = _$inherit(IDBRequest);
    var WorkerGlobalScope = this;
    var ErrorEventHandler = function(event, source, fileno, columnNumber) {
        /// <signature>
        /// <param name='event' type='Event'/>
        /// <param name='source' type='String' optional='true' />
        /// <param name='fileno' type='Number' optional='true' />
        /// <param name='columnNumber' type='Number' optional='true' />
        /// </signature>
        /// <signature>
        /// <param name='event' type='String'/>
        /// <param name='source' type='String' optional='true' />
        /// <param name='fileno' type='Number' optional='true' />
        /// <param name='columnNumber' type='Number' optional='true' />
        /// </signature>
    };
    var PositionCallback = function(position) {
        /// <signature>
        /// <param name='position' type='Position'/>
        /// </signature>
    };
    var PositionErrorCallback = function(error) {
        /// <signature>
        /// <param name='error' type='PositionError'/>
        /// </signature>
    };
    var MediaQueryListListener = function(mql) {
        /// <signature>
        /// <param name='mql' type='MediaQueryList'/>
        /// </signature>
    };
    var MSLaunchUriCallback = function() {
    };
    var FrameRequestCallback = function(time) {
        /// <signature>
        /// <param name='time' type='Number'/>
        /// </signature>
    };
    var MutationCallback = function(mutations, observer) {
        /// <signature>
        /// <param name='mutations' type='Array' elementType='MutationRecord' />
        /// <param name='observer' type='MutationObserver'/>
        /// </signature>
    };
    var DecodeSuccessCallback = function(decodedData) {
        /// <signature>
        /// <param name='decodedData' type='AudioBuffer'/>
        /// </signature>
    };
    var DecodeErrorCallback = function() {
    };
    var FunctionStringCallback = function(data) {
        /// <signature>
        /// <param name='data' type='String'/>
        /// </signature>
    };
    var NavigatorUserMediaSuccessCallback = function(stream) {
        /// <signature>
        /// <param name='stream' type='MediaStream'/>
        /// </signature>
    };
    var NavigatorUserMediaErrorCallback = function(error) {
        /// <signature>
        /// <param name='error' type='MediaStreamError'/>
        /// </signature>
    };
    
    /* -- type: Blob -- */
    
    Blob.size = 0;
    Blob.type = '';
    Blob.msClose = function() {
    };
    Blob.msDetachStream = function() {
        /// <signature>
        /// <returns type='Object'/>
        /// </signature>
        return {};
    };
    Blob.slice = function(start, end, contentType) {
        /// <signature>
        /// <param name='start' type='Number' optional='true' />
        /// <param name='end' type='Number' optional='true' />
        /// <param name='contentType' type='String' optional='true' />
        /// <returns type='Blob'/>
        /// </signature>
        return Blob;
    };
    
    /* -- type: Console -- */
    
    Console.assert = function(test, message, optionalParams) {
        /// <signature>
        /// <param name='test' type='Boolean' optional='true' />
        /// <param name='message' type='String' optional='true' />
        /// <param name='optionalParams' type='Object'/>
        /// </signature>
    };
    Console.clear = function() {
    };
    Console.count = function(countTitle) {
        /// <signature>
        /// <param name='countTitle' type='String' optional='true' />
        /// </signature>
    };
    Console.debug = function(message, optionalParams) {
        /// <signature>
        /// <param name='message' type='String' optional='true' />
        /// <param name='optionalParams' type='Object'/>
        /// </signature>
    };
    Console.dir = function(value, optionalParams) {
        /// <signature>
        /// <param name='value' type='Object' optional='true' />
        /// <param name='optionalParams' type='Object'/>
        /// </signature>
    };
    Console.dirxml = function(value) {
        /// <signature>
        /// <param name='value' type='Object'/>
        /// </signature>
    };
    Console.error = function(message, optionalParams) {
        /// <signature>
        /// <param name='message' type='String' optional='true' />
        /// <param name='optionalParams' type='Object'/>
        /// </signature>
    };
    Console.group = function(groupTitle) {
        /// <signature>
        /// <param name='groupTitle' type='String' optional='true' />
        /// </signature>
    };
    Console.groupCollapsed = function(groupTitle) {
        /// <signature>
        /// <param name='groupTitle' type='String' optional='true' />
        /// </signature>
    };
    Console.groupEnd = function() {
    };
    Console.info = function(message, optionalParams) {
        /// <signature>
        /// <param name='message' type='String' optional='true' />
        /// <param name='optionalParams' type='Object'/>
        /// </signature>
    };
    Console.log = function(message, optionalParams) {
        /// <signature>
        /// <param name='message' type='String' optional='true' />
        /// <param name='optionalParams' type='Object'/>
        /// </signature>
    };
    Console.msIsIndependentlyComposed = function(element) {
        /// <signature>
        /// <param name='element' type='Object'/>
        /// <returns type='Boolean'/>
        /// </signature>
        return false;
    };
    Console.profile = function(reportName) {
        /// <signature>
        /// <param name='reportName' type='String' optional='true' />
        /// </signature>
    };
    Console.profileEnd = function() {
    };
    Console.select = function(element) {
        /// <signature>
        /// <param name='element' type='Object'/>
        /// </signature>
    };
    Console.time = function(timerName) {
        /// <signature>
        /// <param name='timerName' type='String' optional='true' />
        /// </signature>
    };
    Console.timeEnd = function(timerName) {
        /// <signature>
        /// <param name='timerName' type='String' optional='true' />
        /// </signature>
    };
    Console.trace = function() {
    };
    Console.warn = function(message, optionalParams) {
        /// <signature>
        /// <param name='message' type='String' optional='true' />
        /// <param name='optionalParams' type='Object'/>
        /// </signature>
    };
    
    /* -- type: DOMError -- */
    
    DOMError.name = '';
    DOMError.toString = function() {
        /// <signature>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    
    /* -- type: DOMException -- */
    
    DOMException.code = 0;
    DOMException.message = '';
    DOMException.name = '';
    DOMException.ABORT_ERR = 20;
    DOMException.DATA_CLONE_ERR = 25;
    DOMException.DOMSTRING_SIZE_ERR = 2;
    DOMException.HIERARCHY_REQUEST_ERR = 3;
    DOMException.INDEX_SIZE_ERR = 1;
    DOMException.INUSE_ATTRIBUTE_ERR = 10;
    DOMException.INVALID_ACCESS_ERR = 15;
    DOMException.INVALID_CHARACTER_ERR = 5;
    DOMException.INVALID_MODIFICATION_ERR = 13;
    DOMException.INVALID_NODE_TYPE_ERR = 24;
    DOMException.INVALID_STATE_ERR = 11;
    DOMException.NAMESPACE_ERR = 14;
    DOMException.NETWORK_ERR = 19;
    DOMException.NOT_FOUND_ERR = 8;
    DOMException.NOT_SUPPORTED_ERR = 9;
    DOMException.NO_DATA_ALLOWED_ERR = 6;
    DOMException.NO_MODIFICATION_ALLOWED_ERR = 7;
    DOMException.PARSE_ERR = 81;
    DOMException.QUOTA_EXCEEDED_ERR = 22;
    DOMException.SECURITY_ERR = 18;
    DOMException.SERIALIZE_ERR = 82;
    DOMException.SYNTAX_ERR = 12;
    DOMException.TIMEOUT_ERR = 23;
    DOMException.TYPE_MISMATCH_ERR = 17;
    DOMException.URL_MISMATCH_ERR = 21;
    DOMException.VALIDATION_ERR = 16;
    DOMException.WRONG_DOCUMENT_ERR = 4;
    DOMException.toString = function() {
        /// <signature>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    
    /* -- type: DOMStringList -- */
    
    DOMStringList.length = 0;
    DOMStringList.contains = function(str) {
        /// <signature>
        /// <param name='str' type='String'/>
        /// <returns type='Boolean'/>
        /// </signature>
        return false;
    };
    DOMStringList.item = function(index) {
        /// <signature>
        /// <param name='index' type='Number'/>
        /// <returns type='String'/>
        /// </signature>
        return this[index] || _$getTrackingNull('');
    };
    /* Add a single array element */
    DOMStringList[0] = _$getTrackingNull('');
    
    /* -- type: Event -- */
    
    EventCtor.AT_TARGET = 2;
    EventCtor.BUBBLING_PHASE = 3;
    EventCtor.CAPTURING_PHASE = 1;
    Event.bubbles = false;
    Event.cancelBubble = false;
    Event.cancelable = false;
    Event.currentTarget = EventTarget;
    Event.defaultPrevented = false;
    Event.eventPhase = 0;
    Event.isTrusted = false;
    Event.returnValue = false;
    Event.srcElement = {};
    Event.target = EventTarget;
    Event.timeStamp = 0;
    Event.type = '';
    Event.AT_TARGET = 2;
    Event.BUBBLING_PHASE = 3;
    Event.CAPTURING_PHASE = 1;
    Event.initEvent = function(eventTypeArg, canBubbleArg, cancelableArg) {
        /// <signature>
        /// <param name='eventTypeArg' type='String'/>
        /// <param name='canBubbleArg' type='Boolean'/>
        /// <param name='cancelableArg' type='Boolean'/>
        /// </signature>
    };
    Event.preventDefault = function() {
    };
    Event.stopImmediatePropagation = function() {
    };
    Event.stopPropagation = function() {
    };
    
    /* -- type: EventTarget -- */
    
    EventTarget.addEventListener = function(type, listener, useCapture) {
        /// <signature>
        /// <param name='type' type='String'/>
        /// <param name='listener' type='EventListener'/>
        /// <param name='useCapture' type='Boolean' optional='true' />
        /// </signature>
        _eventManager.add(this, type, listener);
    };
    EventTarget.dispatchEvent = function(evt) {
        /// <signature>
        /// <param name='evt' type='Event'/>
        /// <returns type='Boolean'/>
        /// </signature>
        return false;
    };
    EventTarget.removeEventListener = function(type, listener, useCapture) {
        /// <signature>
        /// <param name='type' type='String'/>
        /// <param name='listener' type='EventListener'/>
        /// <param name='useCapture' type='Boolean' optional='true' />
        /// </signature>
    };
    
    /* -- type: FileList -- */
    
    FileList.length = 0;
    FileList.item = function(index) {
        /// <signature>
        /// <param name='index' type='Number'/>
        /// <returns type='File'/>
        /// </signature>
        return this[index] || _$getTrackingNull(Object.create(File));
    };
    /* Add a single array element */
    FileList[0] = _$getTrackingNull(Object.create(File));
    
    /* -- type: IDBCursor -- */
    
    IDBCursor.direction = '';
    IDBCursor.key = {};
    IDBCursor.primaryKey = {};
    IDBCursor.source = {};
    IDBCursor.NEXT = "next";
    IDBCursor.NEXT_NO_DUPLICATE = "nextunique";
    IDBCursor.PREV = "prev";
    IDBCursor.PREV_NO_DUPLICATE = "prevunique";
    IDBCursor.advance = function(count) {
        /// <signature>
        /// <param name='count' type='Number'/>
        /// </signature>
    };
    IDBCursor.continue = function(key) {
        /// <signature>
        /// <param name='key' type='Object' optional='true' />
        /// </signature>
    };
    IDBCursor.delete = function() {
        /// <signature>
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this, undefined);
    };
    IDBCursor.update = function(value) {
        /// <signature>
        /// <param name='value' type='Object'/>
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this, value);
    };
    
    /* -- type: IDBFactory -- */
    
    IDBFactory.cmp = function(first, second) {
        /// <signature>
        /// <param name='first' type='Object'/>
        /// <param name='second' type='Object'/>
        /// <returns type='Number'/>
        /// </signature>
        return 0;
    };
    IDBFactory.deleteDatabase = function(name) {
        /// <signature>
        /// <param name='name' type='String'/>
        /// <returns type='IDBOpenDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBOpenDBRequest, null, null);
    };
    IDBFactory.open = function(name, version) {
        /// <signature>
        /// <param name='name' type='String'/>
        /// <param name='version' type='Number' optional='true' />
        /// <returns type='IDBOpenDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBOpenDBRequest, null, Object.create(IDBDatabase));
    };
    
    /* -- type: IDBIndex -- */
    
    IDBIndex.keyPath = '';
    IDBIndex.name = '';
    IDBIndex.objectStore = IDBObjectStore;
    IDBIndex.unique = false;
    IDBIndex.count = function(key) {
        /// <signature>
        /// <param name='key' type='Object' optional='true' />
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this, 0);
    };
    IDBIndex.get = function(key) {
        /// <signature>
        /// <param name='key' type='Object'/>
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this.objectStore, {});
    };
    IDBIndex.getKey = function(key) {
        /// <signature>
        /// <param name='key' type='Object'/>
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this.objectStore, {});
    };
    IDBIndex.openCursor = function(range, direction) {
        /// <signature>
        /// <param name='range' type='IDBKeyRange' optional='true' />
        /// <param name='direction' type='String' optional='true' />
        /// <returns type='IDBRequest'/>
        /// </signature>
        var cursor = Object.create(IDBCursorWithValue); cursor.source = this; return _createIDBRequest(IDBRequest, this, cursor);
    };
    IDBIndex.openKeyCursor = function(range, direction) {
        /// <signature>
        /// <param name='range' type='IDBKeyRange' optional='true' />
        /// <param name='direction' type='String' optional='true' />
        /// <returns type='IDBRequest'/>
        /// </signature>
        var cursor = Object.create(IDBCursor); cursor.source = this; return _createIDBRequest(IDBRequest, this.objectStore, cursor);
    };
    
    /* -- type: IDBKeyRange -- */
    
    IDBKeyRange.lower = {};
    IDBKeyRange.lowerOpen = false;
    IDBKeyRange.upper = {};
    IDBKeyRange.upperOpen = false;
    IDBKeyRange.bound = function(lower, upper, lowerOpen, upperOpen) {
        /// <signature>
        /// <param name='lower' type='Object'/>
        /// <param name='upper' type='Object'/>
        /// <param name='lowerOpen' type='Boolean' optional='true' />
        /// <param name='upperOpen' type='Boolean' optional='true' />
        /// <returns type='IDBKeyRange'/>
        /// </signature>
        return IDBKeyRange;
    };
    IDBKeyRange.lowerBound = function(bound, open) {
        /// <signature>
        /// <param name='bound' type='Object'/>
        /// <param name='open' type='Boolean' optional='true' />
        /// <returns type='IDBKeyRange'/>
        /// </signature>
        return IDBKeyRange;
    };
    IDBKeyRange.only = function(value) {
        /// <signature>
        /// <param name='value' type='Object'/>
        /// <returns type='IDBKeyRange'/>
        /// </signature>
        return IDBKeyRange;
    };
    IDBKeyRange.upperBound = function(bound, open) {
        /// <signature>
        /// <param name='bound' type='Object'/>
        /// <param name='open' type='Boolean' optional='true' />
        /// <returns type='IDBKeyRange'/>
        /// </signature>
        return IDBKeyRange;
    };
    
    /* -- type: IDBObjectStore -- */
    
    IDBObjectStore.indexNames = DOMStringList;
    IDBObjectStore.keyPath = '';
    IDBObjectStore.name = '';
    IDBObjectStore.transaction = IDBTransaction;
    IDBObjectStore.add = function(value, key) {
        /// <signature>
        /// <param name='value' type='Object'/>
        /// <param name='key' type='Object' optional='true' />
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this, key);
    };
    IDBObjectStore.clear = function() {
        /// <signature>
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this, undefined);
    };
    IDBObjectStore.count = function(key) {
        /// <signature>
        /// <param name='key' type='Object' optional='true' />
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this, 0);
    };
    IDBObjectStore.createIndex = function(name, keyPath, optionalParameters) {
        /// <signature>
        /// <param name='name' type='String'/>
        /// <param name='keyPath' type='String'/>
        /// <param name='optionalParameters' type='Object' optional='true' />
        /// <returns type='IDBIndex'/>
        /// </signature>
        return IDBIndex;
    };
    IDBObjectStore.delete = function(key) {
        /// <signature>
        /// <param name='key' type='Object'/>
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this, undefined);
    };
    IDBObjectStore.deleteIndex = function(indexName) {
        /// <signature>
        /// <param name='indexName' type='String'/>
        /// </signature>
    };
    IDBObjectStore.get = function(key) {
        /// <signature>
        /// <param name='key' type='Object'/>
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this, {});
    };
    IDBObjectStore.index = function(name) {
        /// <signature>
        /// <param name='name' type='String'/>
        /// <returns type='IDBIndex'/>
        /// </signature>
        return IDBIndex;
    };
    IDBObjectStore.openCursor = function(range, direction) {
        /// <signature>
        /// <param name='range' type='Object' optional='true' />
        /// <param name='direction' type='String' optional='true' />
        /// <returns type='IDBRequest'/>
        /// </signature>
        var cursor = Object.create(IDBCursorWithValue); cursor.source = this; return _createIDBRequest(IDBRequest, this, cursor);
    };
    IDBObjectStore.put = function(value, key) {
        /// <signature>
        /// <param name='value' type='Object'/>
        /// <param name='key' type='Object' optional='true' />
        /// <returns type='IDBRequest'/>
        /// </signature>
        return _createIDBRequest(IDBRequest, this, key);
    };
    
    /* -- type: ImageData -- */
    
    ImageData.data = new UInt8ClampedArray();
    ImageData.height = 0;
    ImageData.width = 0;
    
    /* -- type: MSApp -- */
    
    MSApp.CURRENT = "current";
    MSApp.HIGH = "high";
    MSApp.IDLE = "idle";
    MSApp.NORMAL = "normal";
    MSApp.clearTemporaryWebDataAsync = function() {
        /// <signature>
        /// <returns type='MSAppAsyncOperation'/>
        /// </signature>
        return MSAppAsyncOperation;
    };
    MSApp.createBlobFromRandomAccessStream = function(type, seeker) {
        /// <signature>
        /// <param name='type' type='String'/>
        /// <param name='seeker' type='Object'/>
        /// <returns type='Blob'/>
        /// </signature>
        return Blob;
    };
    MSApp.createDataPackage = function(object) {
        /// <signature>
        /// <param name='object' type='Object'/>
        /// <returns type='Object'/>
        /// </signature>
        return {};
    };
    MSApp.createDataPackageFromSelection = function() {
        /// <signature>
        /// <returns type='Object'/>
        /// </signature>
        return {};
    };
    MSApp.createFileFromStorageFile = function(storageFile) {
        /// <signature>
        /// <param name='storageFile' type='Object'/>
        /// <returns type='File'/>
        /// </signature>
        return File;
    };
    MSApp.createStreamFromInputStream = function(type, inputStream) {
        /// <signature>
        /// <param name='type' type='String'/>
        /// <param name='inputStream' type='Object'/>
        /// <returns type='MSStream'/>
        /// </signature>
        return MSStream;
    };
    MSApp.execAsyncAtPriority = function(asynchronousCallback, priority, args) {
        /// <signature>
        /// <param name='asynchronousCallback' type='MSExecAtPriorityFunctionCallback'/>
        /// <param name='priority' type='String'/>
        /// <param name='args' type='Object'/>
        /// </signature>
    };
    MSApp.execAtPriority = function(synchronousCallback, priority, args) {
        /// <signature>
        /// <param name='synchronousCallback' type='MSExecAtPriorityFunctionCallback'/>
        /// <param name='priority' type='String'/>
        /// <param name='args' type='Object'/>
        /// <returns type='Object'/>
        /// </signature>
        return {};
    };
    MSApp.getCurrentPriority = function() {
        /// <signature>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    MSApp.getHtmlPrintDocumentSourceAsync = function(htmlDoc) {
        /// <signature>
        /// <param name='htmlDoc' type='Object'/>
        /// <returns type='Promise'/>
        /// </signature>
        return new Promise(function(resolve, reject) { });
    };
    MSApp.getViewId = function(view) {
        /// <signature>
        /// <param name='view' type='Object'/>
        /// <returns type='Object'/>
        /// </signature>
        return {};
    };
    MSApp.isTaskScheduledAtPriorityOrHigher = function(priority) {
        /// <signature>
        /// <param name='priority' type='String'/>
        /// <returns type='Boolean'/>
        /// </signature>
        return false;
    };
    MSApp.pageHandlesAllApplicationActivations = function(enabled) {
        /// <signature>
        /// <param name='enabled' type='Boolean'/>
        /// </signature>
    };
    MSApp.suppressSubdownloadCredentialPrompts = function(suppress) {
        /// <signature>
        /// <param name='suppress' type='Boolean'/>
        /// </signature>
    };
    MSApp.terminateApp = function(exceptionObject) {
        /// <signature>
        /// <param name='exceptionObject' type='Object'/>
        /// </signature>
    };
    
    /* -- type: MSBlobBuilder -- */
    
    MSBlobBuilder.append = function(data, endings) {
        /// <signature>
        /// <param name='data' type='Object'/>
        /// <param name='endings' type='String' optional='true' />
        /// </signature>
    };
    MSBlobBuilder.getBlob = function(contentType) {
        /// <signature>
        /// <param name='contentType' type='String' optional='true' />
        /// <returns type='Blob'/>
        /// </signature>
        return Blob;
    };
    
    /* -- type: MSStream -- */
    
    MSStream.type = '';
    MSStream.msClose = function() {
    };
    MSStream.msDetachStream = function() {
        /// <signature>
        /// <returns type='Object'/>
        /// </signature>
        return {};
    };
    
    /* -- type: MessageChannel -- */
    
    MessageChannel.port1 = MessagePort;
    MessageChannel.port2 = MessagePort;
    
    /* -- type: EventListener -- */
    
    EventListener.handleEvent = function(evt) {
        /// <signature>
        /// <param name='evt' type='Event'/>
        /// </signature>
    };
    
    /* -- type: AbstractWorker -- */
    
    _events(AbstractWorker, "onerror");
    
    /* -- type: MSBaseReader -- */
    
    MSBaseReader.readyState = 0;
    MSBaseReader.result = {};
    MSBaseReader.DONE = 2;
    MSBaseReader.EMPTY = 0;
    MSBaseReader.LOADING = 1;
    MSBaseReader.abort = function() {
    };
    _events(MSBaseReader, "onabort", "onerror", "onload", "onloadend", "onloadstart", "onprogress");
    
    /* -- type: NavigatorID -- */
    
    NavigatorID.appName = '';
    NavigatorID.appVersion = '';
    NavigatorID.platform = '';
    NavigatorID.product = '';
    NavigatorID.productSub = '';
    NavigatorID.userAgent = '';
    NavigatorID.vendor = '';
    NavigatorID.vendorSub = '';
    
    /* -- type: NavigatorOnLine -- */
    
    NavigatorOnLine.onLine = false;
    
    /* -- type: WindowBase64 -- */
    
    WindowBase64.atob = function(encodedString) {
        /// <signature>
        /// <param name='encodedString' type='String'/>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    WindowBase64.btoa = function(rawString) {
        /// <signature>
        /// <param name='rawString' type='String'/>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    
    /* -- type: WindowConsole -- */
    
    WindowConsole.console = Console;
    
    /* -- type: XMLHttpRequestEventTarget -- */
    
    _events(XMLHttpRequestEventTarget, "onabort", "onerror", "onload", "onloadend", "onloadstart", "onprogress", "ontimeout");
    
    /* -- type: FileReaderSync -- */
    
    FileReaderSync.readAsArrayBuffer = function(blob) {
        /// <signature>
        /// <param name='blob' type='Blob'/>
        /// <returns type='Object'/>
        /// </signature>
        return {};
    };
    FileReaderSync.readAsBinaryString = function(blob) {
        /// <signature>
        /// <param name='blob' type='Blob'/>
        /// </signature>
    };
    FileReaderSync.readAsDataURL = function(blob) {
        /// <signature>
        /// <param name='blob' type='Blob'/>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    FileReaderSync.readAsText = function(blob, encoding) {
        /// <signature>
        /// <param name='blob' type='Blob'/>
        /// <param name='encoding' type='String' optional='true' />
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    
    /* -- type: WorkerLocation -- */
    
    WorkerLocation.hash = '';
    WorkerLocation.host = '';
    WorkerLocation.hostname = '';
    WorkerLocation.href = '';
    WorkerLocation.pathname = '';
    WorkerLocation.port = '';
    WorkerLocation.protocol = '';
    WorkerLocation.search = '';
    WorkerLocation.toString = function() {
        /// <signature>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    
    /* -- type: DedicatedWorkerGlobalScope -- */
    
    DedicatedWorkerGlobalScope.postMessage = function(data) {
        /// <signature>
        /// <param name='data' type='Object'/>
        /// </signature>
    };
    DedicatedWorkerGlobalScope.onmessage = function () {};
    
    /* -- type: CloseEvent -- */
    
    CloseEvent.code = 0;
    CloseEvent.reason = '';
    CloseEvent.wasClean = false;
    CloseEvent.initCloseEvent = function(typeArg, canBubbleArg, cancelableArg, wasCleanArg, codeArg, reasonArg) {
        /// <signature>
        /// <param name='typeArg' type='String'/>
        /// <param name='canBubbleArg' type='Boolean'/>
        /// <param name='cancelableArg' type='Boolean'/>
        /// <param name='wasCleanArg' type='Boolean'/>
        /// <param name='codeArg' type='Number'/>
        /// <param name='reasonArg' type='String'/>
        /// </signature>
    };
    
    /* -- type: ErrorEvent -- */
    
    ErrorEvent.colno = 0;
    ErrorEvent.error = {};
    ErrorEvent.filename = '';
    ErrorEvent.lineno = 0;
    ErrorEvent.message = '';
    ErrorEvent.initErrorEvent = function(typeArg, canBubbleArg, cancelableArg, messageArg, filenameArg, linenoArg) {
        /// <signature>
        /// <param name='typeArg' type='String'/>
        /// <param name='canBubbleArg' type='Boolean'/>
        /// <param name='cancelableArg' type='Boolean'/>
        /// <param name='messageArg' type='String'/>
        /// <param name='filenameArg' type='String'/>
        /// <param name='linenoArg' type='Number'/>
        /// </signature>
    };
    
    /* -- type: File -- */
    
    File.lastModifiedDate = {};
    File.name = '';
    
    /* -- type: FileReader -- */
    
    _$implement(FileReader, MSBaseReader);
    FileReader.error = DOMError;
    FileReader.readAsArrayBuffer = function(blob) {
        /// <signature>
        /// <param name='blob' type='Blob'/>
        /// </signature>
    };
    FileReader.readAsBinaryString = function(blob) {
        /// <signature>
        /// <param name='blob' type='Blob'/>
        /// </signature>
    };
    FileReader.readAsDataURL = function(blob) {
        /// <signature>
        /// <param name='blob' type='Blob'/>
        /// </signature>
    };
    FileReader.readAsText = function(blob, encoding) {
        /// <signature>
        /// <param name='blob' type='Blob'/>
        /// <param name='encoding' type='String' optional='true' />
        /// </signature>
    };
    
    /* -- type: IDBCursorWithValue -- */
    
    IDBCursorWithValue.value = {};
    
    /* -- type: IDBDatabase -- */
    
    IDBDatabase.name = '';
    IDBDatabase.objectStoreNames = DOMStringList;
    IDBDatabase.version = '';
    IDBDatabase.close = function() {
    };
    IDBDatabase.createObjectStore = function(name, optionalParameters) {
        /// <signature>
        /// <param name='name' type='String'/>
        /// <param name='optionalParameters' type='Object' optional='true' />
        /// <returns type='IDBObjectStore'/>
        /// </signature>
        return IDBObjectStore;
    };
    IDBDatabase.deleteObjectStore = function(name) {
        /// <signature>
        /// <param name='name' type='String'/>
        /// </signature>
    };
    IDBDatabase.transaction = function(storeNames, mode) {
        /// <signature>
        /// <param name='storeNames' type='Object'/>
        /// <param name='mode' type='String' optional='true' />
        /// <returns type='IDBTransaction'/>
        /// </signature>
        return IDBTransaction;
    };
    _events(IDBDatabase, "onabort", "onerror");
    
    /* -- type: IDBRequest -- */
    
    IDBRequest.error = DOMError;
    IDBRequest.readyState = '';
    IDBRequest.result = {};
    IDBRequest.source = {};
    IDBRequest.transaction = IDBTransaction;
    _events(IDBRequest, "onerror", "onsuccess");
    
    /* -- type: IDBTransaction -- */
    
    IDBTransaction.db = IDBDatabase;
    IDBTransaction.error = DOMError;
    IDBTransaction.mode = '';
    IDBTransaction.READ_ONLY = "readonly";
    IDBTransaction.READ_WRITE = "readwrite";
    IDBTransaction.VERSION_CHANGE = "versionchange";
    IDBTransaction.abort = function() {
    };
    IDBTransaction.objectStore = function(name) {
        /// <signature>
        /// <param name='name' type='String'/>
        /// <returns type='IDBObjectStore'/>
        /// </signature>
        return IDBObjectStore;
    };
    _events(IDBTransaction, "onabort", "oncomplete", "onerror");
    
    /* -- type: IDBVersionChangeEvent -- */
    
    IDBVersionChangeEvent.newVersion = 0;
    IDBVersionChangeEvent.oldVersion = 0;
    
    /* -- type: MSStreamReader -- */
    
    _$implement(MSStreamReader, MSBaseReader);
    MSStreamReader.error = DOMError;
    MSStreamReader.readAsArrayBuffer = function(stream, size) {
        /// <signature>
        /// <param name='stream' type='MSStream'/>
        /// <param name='size' type='Number' optional='true' />
        /// </signature>
    };
    MSStreamReader.readAsBinaryString = function(stream, size) {
        /// <signature>
        /// <param name='stream' type='MSStream'/>
        /// <param name='size' type='Number' optional='true' />
        /// </signature>
    };
    MSStreamReader.readAsBlob = function(stream, size) {
        /// <signature>
        /// <param name='stream' type='MSStream'/>
        /// <param name='size' type='Number' optional='true' />
        /// </signature>
    };
    MSStreamReader.readAsDataURL = function(stream, size) {
        /// <signature>
        /// <param name='stream' type='MSStream'/>
        /// <param name='size' type='Number' optional='true' />
        /// </signature>
    };
    MSStreamReader.readAsText = function(stream, encoding, size) {
        /// <signature>
        /// <param name='stream' type='MSStream'/>
        /// <param name='encoding' type='String' optional='true' />
        /// <param name='size' type='Number' optional='true' />
        /// </signature>
    };
    
    /* -- type: MessageEvent -- */
    
    MessageEvent.data = {};
    MessageEvent.origin = '';
    MessageEvent.ports = {};
    MessageEvent.source = {};
    MessageEvent.initMessageEvent = function(typeArg, canBubbleArg, cancelableArg, dataArg, originArg, lastEventIdArg, sourceArg) {
        /// <signature>
        /// <param name='typeArg' type='String'/>
        /// <param name='canBubbleArg' type='Boolean'/>
        /// <param name='cancelableArg' type='Boolean'/>
        /// <param name='dataArg' type='Object'/>
        /// <param name='originArg' type='String'/>
        /// <param name='lastEventIdArg' type='String'/>
        /// <param name='sourceArg' type='Object'/>
        /// </signature>
    };
    
    /* -- type: MessagePort -- */
    
    MessagePort.close = function() {
    };
    MessagePort.postMessage = function(message, ports) {
        /// <signature>
        /// <param name='message' type='Object' optional='true' />
        /// <param name='ports' type='Object' optional='true' />
        /// </signature>
    };
    MessagePort.start = function() {
    };
    _events(MessagePort, "onmessage");
    
    /* -- type: ProgressEvent -- */
    
    ProgressEvent.lengthComputable = false;
    ProgressEvent.loaded = 0;
    ProgressEvent.total = 0;
    ProgressEvent.initProgressEvent = function(typeArg, canBubbleArg, cancelableArg, lengthComputableArg, loadedArg, totalArg) {
        /// <signature>
        /// <param name='typeArg' type='String'/>
        /// <param name='canBubbleArg' type='Boolean'/>
        /// <param name='cancelableArg' type='Boolean'/>
        /// <param name='lengthComputableArg' type='Boolean'/>
        /// <param name='loadedArg' type='Number'/>
        /// <param name='totalArg' type='Number'/>
        /// </signature>
    };
    
    /* -- type: WebSocket -- */
    
    WebSocketCtor.CLOSED = 3;
    WebSocketCtor.CLOSING = 2;
    WebSocketCtor.CONNECTING = 0;
    WebSocketCtor.OPEN = 1;
    WebSocket.binaryType = '';
    WebSocket.bufferedAmount = 0;
    WebSocket.extensions = '';
    WebSocket.protocol = '';
    WebSocket.readyState = 0;
    WebSocket.url = '';
    WebSocket.CLOSED = 3;
    WebSocket.CLOSING = 2;
    WebSocket.CONNECTING = 0;
    WebSocket.OPEN = 1;
    WebSocket.close = function(code, reason) {
        /// <signature>
        /// <param name='code' type='Number' optional='true' />
        /// <param name='reason' type='String' optional='true' />
        /// </signature>
    };
    WebSocket.send = function(data) {
        /// <signature>
        /// <param name='data' type='Object'/>
        /// </signature>
    };
    _events(WebSocket, "onclose", "onerror", "onmessage", "onopen");
    
    /* -- type: Worker -- */
    
    _$implement(Worker, AbstractWorker);
    Worker.postMessage = function(message, ports) {
        /// <signature>
        /// <param name='message' type='Object'/>
        /// <param name='ports' type='Object' optional='true' />
        /// </signature>
    };
    Worker.terminate = function() {
    };
    _events(Worker, "onmessage", "onerror");
    
    /* -- type: XMLHttpRequest -- */
    
    _$implement(XMLHttpRequest, XMLHttpRequestEventTarget);
    XMLHttpRequestCtor.DONE = 4;
    XMLHttpRequestCtor.HEADERS_RECEIVED = 2;
    XMLHttpRequestCtor.LOADING = 3;
    XMLHttpRequestCtor.OPENED = 1;
    XMLHttpRequestCtor.UNSENT = 0;
    XMLHttpRequest.msCaching = '';
    XMLHttpRequest.readyState = 0;
    XMLHttpRequest.response = {};
    XMLHttpRequest.responseBody = {};
    XMLHttpRequest.responseText = '';
    XMLHttpRequest.responseType = '';
    XMLHttpRequest.responseXML = {};
    XMLHttpRequest.status = 0;
    XMLHttpRequest.statusText = '';
    XMLHttpRequest.timeout = 0;
    XMLHttpRequest.upload = XMLHttpRequestUpload;
    XMLHttpRequest.withCredentials = false;
    XMLHttpRequest.DONE = 4;
    XMLHttpRequest.HEADERS_RECEIVED = 2;
    XMLHttpRequest.LOADING = 3;
    XMLHttpRequest.OPENED = 1;
    XMLHttpRequest.UNSENT = 0;
    XMLHttpRequest.abort = function() {
    };
    XMLHttpRequest.create = function() {
        /// <signature>
        /// <returns type='XMLHttpRequest'/>
        /// </signature>
        return XMLHttpRequest;
    };
    XMLHttpRequest.getAllResponseHeaders = function() {
        /// <signature>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    XMLHttpRequest.getResponseHeader = function(header) {
        /// <signature>
        /// <param name='header' type='String'/>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    XMLHttpRequest.msCachingEnabled = function() {
        /// <signature>
        /// <returns type='Boolean'/>
        /// </signature>
        return false;
    };
    XMLHttpRequest.open = function(method, url, async, user, password) {
        /// <signature>
        /// <param name='method' type='String'/>
        /// <param name='url' type='String'/>
        /// <param name='async' type='Boolean' optional='true' />
        /// <param name='user' type='String' optional='true' />
        /// <param name='password' type='String' optional='true' />
        /// </signature>
    };
    XMLHttpRequest.overrideMimeType = function(mime) {
        /// <signature>
        /// <param name='mime' type='String'/>
        /// </signature>
    };
    XMLHttpRequest.send = function(data) {
        /// <signature>
        /// <param name='data' type='Object' optional='true' />
        /// </signature>
        /// <signature>
        /// <param name='data' type='String' optional='true' />
        /// </signature>
        this.status = 200; this.readyState = XMLHttpRequest.DONE; this.status = 4; this.statusText = "OK";
    };
    XMLHttpRequest.setRequestHeader = function(header, value) {
        /// <signature>
        /// <param name='header' type='String'/>
        /// <param name='value' type='String'/>
        /// </signature>
    };
    _events(XMLHttpRequest, "onreadystatechange", "onabort", "onerror", "onload", "onloadend", "onloadstart", "onprogress", "ontimeout");
    
    /* -- type: WorkerNavigator -- */
    
    _$implement(WorkerNavigator, NavigatorID);
    _$implement(WorkerNavigator, NavigatorOnLine);
    
    /* -- type: WorkerUtils -- */
    
    _$implement(WorkerUtils, WindowBase64);
    WorkerUtils.indexedDB = IDBFactory;
    WorkerUtils.msIndexedDB = IDBFactory;
    WorkerUtils.navigator = WorkerNavigator;
    WorkerUtils.clearImmediate = function(handle) {
        /// <signature>
        /// <param name='handle' type='Number'/>
        /// </signature>
        _$clearTimeout(handle);
    };
    WorkerUtils.clearInterval = function(handle) {
        /// <signature>
        /// <param name='handle' type='Number'/>
        /// </signature>
        _$clearTimeout(handle);
    };
    WorkerUtils.clearTimeout = function(handle) {
        /// <signature>
        /// <param name='handle' type='Number'/>
        /// </signature>
        _$clearTimeout(handle);
    };
    WorkerUtils.importScripts = function(urls) {
        /// <signature>
        /// <param name='urls' type='String'/>
        /// </signature>
        for (var i = 0; i < arguments.length; i++) _$asyncRequests.add({ src: arguments[i] });
    };
    WorkerUtils.setImmediate = function(handler, args) {
        /// <signature>
        /// <param name='handler' type='Object'/>
        /// <param name='args' type='Object' optional='true' />
        /// <returns type='Number'/>
        /// </signature>
        return _$setTimeout(handler, 0, args);
    };
    WorkerUtils.setInterval = function(handler, timeout, args) {
        /// <signature>
        /// <param name='handler' type='Object'/>
        /// <param name='timeout' type='Object' optional='true' />
        /// <param name='args' type='Object'/>
        /// <returns type='Number'/>
        /// </signature>
        return _$setTimeout(handler, timeout, args);
    };
    WorkerUtils.setTimeout = function(handler, timeout, args) {
        /// <signature>
        /// <param name='handler' type='Object'/>
        /// <param name='timeout' type='Object' optional='true' />
        /// <param name='args' type='Object'/>
        /// <returns type='Number'/>
        /// </signature>
        return _$setTimeout(handler, timeout, args);
    };
    
    /* -- type: IDBOpenDBRequest -- */
    
    _events(IDBOpenDBRequest, "onblocked", "onupgradeneeded", "onerror", "onsuccess");
    
    /* -- type: WorkerGlobalScope -- */
    
    _$implement(WorkerGlobalScope, WorkerUtils);
    _$implement(WorkerGlobalScope, DedicatedWorkerGlobalScope);
    _$implement(WorkerGlobalScope, WindowConsole);
    _$implement(WorkerGlobalScope, EventTarget);
    WorkerGlobalScope.location = WorkerLocation;
    WorkerGlobalScope.self = _$getTrackingNull(Object.create(WorkerGlobalScope));
    WorkerGlobalScope.close = function() {
    };
    WorkerGlobalScope.msWriteProfilerMark = function(profilerMarkName) {
        /// <signature>
        /// <param name='profilerMarkName' type='String'/>
        /// </signature>
    };
    WorkerGlobalScope.toString = function() {
        /// <signature>
        /// <returns type='String'/>
        /// </signature>
        return '';
    };
    WorkerGlobalScope.onerror = function () {};
    WorkerGlobalScope.onmessage = function () {};

    function _publicInterface(name, interface, interfacePrototype) {
        _$nonRemovable(interface);
        WorkerGlobalScope[name] = interface;
        WorkerGlobalScope[name].prototype = interfacePrototype;
    }

    function _publicObject(name, obj) {
        _$nonRemovable(obj);
        WorkerGlobalScope[name] = obj;
    }
    
    _publicInterface('IDBOpenDBRequest', {}, IDBOpenDBRequest);
    _publicInterface('WorkerGlobalScope', {}, WorkerGlobalScope);
    _publicInterface('ProgressEvent', {}, ProgressEvent);
    _publicInterface('MessagePort', {}, MessagePort);
    _publicInterface('MessageEvent', {}, MessageEvent);
    _publicInterface('IDBVersionChangeEvent', {}, IDBVersionChangeEvent);
    _publicInterface('IDBTransaction', {'READ_ONLY' : readonly,'READ_WRITE' : readwrite,'VERSION_CHANGE' : versionchange}, IDBTransaction);
    _publicInterface('IDBRequest', {}, IDBRequest);
    _publicInterface('IDBDatabase', {}, IDBDatabase);
    _publicInterface('IDBCursorWithValue', {}, IDBCursorWithValue);
    _publicInterface('File', {}, File);
    _publicInterface('ErrorEvent', {}, ErrorEvent);
    _publicInterface('CloseEvent', {}, CloseEvent);
    _publicInterface('WorkerNavigator', {}, WorkerNavigator);
    _publicInterface('WorkerLocation', {}, WorkerLocation);
    _publicInterface('MSStream', {}, MSStream);
    _publicObject('MSApp', MSApp);
    _publicInterface('ImageData', {}, ImageData);
    _publicInterface('IDBObjectStore', {}, IDBObjectStore);
    _publicInterface('IDBKeyRange', {'bound' : IDBKeyRange.bound,'lowerBound' : IDBKeyRange.lowerBound,'only' : IDBKeyRange.only,'upperBound' : IDBKeyRange.upperBound}, IDBKeyRange);
    _publicInterface('IDBIndex', {}, IDBIndex);
    _publicInterface('IDBFactory', {}, IDBFactory);
    _publicInterface('IDBCursor', {'NEXT' : next,'NEXT_NO_DUPLICATE' : nextunique,'PREV' : prev,'PREV_NO_DUPLICATE' : prevunique}, IDBCursor);
    _publicInterface('FileList', {}, FileList);
    _publicInterface('EventTarget', {}, EventTarget);
    _publicInterface('DOMStringList', {}, DOMStringList);
    _publicInterface('DOMException', {'ABORT_ERR' : 20,'DATA_CLONE_ERR' : 25,'DOMSTRING_SIZE_ERR' : 2,'HIERARCHY_REQUEST_ERR' : 3,'INDEX_SIZE_ERR' : 1,'INUSE_ATTRIBUTE_ERR' : 10,'INVALID_ACCESS_ERR' : 15,'INVALID_CHARACTER_ERR' : 5,'INVALID_MODIFICATION_ERR' : 13,'INVALID_NODE_TYPE_ERR' : 24,'INVALID_STATE_ERR' : 11,'NAMESPACE_ERR' : 14,'NETWORK_ERR' : 19,'NOT_FOUND_ERR' : 8,'NOT_SUPPORTED_ERR' : 9,'NO_DATA_ALLOWED_ERR' : 6,'NO_MODIFICATION_ALLOWED_ERR' : 7,'PARSE_ERR' : 81,'QUOTA_EXCEEDED_ERR' : 22,'SECURITY_ERR' : 18,'SERIALIZE_ERR' : 82,'SYNTAX_ERR' : 12,'TIMEOUT_ERR' : 23,'TYPE_MISMATCH_ERR' : 17,'URL_MISMATCH_ERR' : 21,'VALIDATION_ERR' : 16,'WRONG_DOCUMENT_ERR' : 4}, DOMException);
    _publicInterface('DOMError', {}, DOMError);
    _publicInterface('Console', {}, Console);
    _publicInterface('XMLHttpRequest', XMLHttpRequestCtor , XMLHttpRequest);
    _publicInterface('Worker', WorkerCtor , Worker);
    _publicInterface('WebSocket', WebSocketCtor , WebSocket);
    _publicInterface('MSStreamReader', MSStreamReaderCtor , MSStreamReader);
    _publicInterface('FileReader', FileReaderCtor , FileReader);
    _publicInterface('FileReaderSync', FileReaderSyncCtor , FileReaderSync);
    _publicInterface('MessageChannel', MessageChannelCtor , MessageChannel);
    _publicInterface('MSBlobBuilder', MSBlobBuilderCtor , MSBlobBuilder);
    _publicInterface('Event', EventCtor , Event);
    _publicInterface('Blob', BlobCtor , Blob);

    this.XMLHttpRequest.create = this.XMLHttpRequest;
})();

function _$getActiveXObject(className, location) {
    if ((/XMLHTTP/i).test(className))
        return new window.XMLHttpRequest();
}

// SIG // Begin signature block
// SIG // MIIkDAYJKoZIhvcNAQcCoIIj/TCCI/kCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // +Dqw1v+RtXl6JP2mjOdCOQzZSVQupn9g5iVV1WIfk+Gg
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFdEwghXNAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggbwwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIH+leehPuTbx9cNKj11NcmUCBC0nF+Z+cLJpIeyD
// SIG // rNHuMFAGCisGAQQBgjcCAQwxQjBAoCaAJABkAGUAZABp
// SIG // AGMAYQB0AGUAZAB3AG8AcgBrAGUAcgAuAGoAc6EWgBRo
// SIG // dHRwOi8vbWljcm9zb2Z0LmNvbTANBgkqhkiG9w0BAQEF
// SIG // AASCAQBiTau0ta+trdTeNv9Qa/JjpFtElQNhiq7HZiqL
// SIG // STrGHsUGl0i9JYvwRoSzNDmB3QQApTtiPmHSNAr/iVME
// SIG // HzDQWLD/PV+TydTZJ2lvR1S2llsLKgDU27pkRyjRLB0E
// SIG // CfOf/TPqhRmVPdQOlvzV39l4hfow17Lgo3nF3SHh/35E
// SIG // EBcn3DCDX2v4laskIsKp7crTEYpCSZLdvFhRlvPY4TZ4
// SIG // 8rnxzY6CeJEpV9jtVLp8Ilg8k5Zf8XyNmepjLcFMT6Qj
// SIG // YBJb+9W0nW71cbvPppTP3ra/q5Gqx4oXmzGoewhf2D+i
// SIG // cbty5r/rpPNEfGnvgUO6FJHVLiNSWlpXT9QsEci3oYIT
// SIG // TTCCE0kGCisGAQQBgjcDAwExghM5MIITNQYJKoZIhvcN
// SIG // AQcCoIITJjCCEyICAQMxDzANBglghkgBZQMEAgEFADCC
// SIG // AT0GCyqGSIb3DQEJEAEEoIIBLASCASgwggEkAgEBBgor
// SIG // BgEEAYRZCgMBMDEwDQYJYIZIAWUDBAIBBQAEIBC05dlV
// SIG // r/jDwz3qwnefrBy3kZiraitj/P4QHKzJ+8ClAgZYi6Ls
// SIG // Qd8YEzIwMTcwMjA5MDM0MzMxLjkzMVowBwIBAYACAfSg
// SIG // gbmkgbYwgbMxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNV
// SIG // BAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIgRFNFIEVT
// SIG // TjpDMEY0LTMwODYtREVGODElMCMGA1UEAxMcTWljcm9z
// SIG // b2Z0IFRpbWUtU3RhbXAgU2VydmljZaCCDtAwggZxMIIE
// SIG // WaADAgECAgphCYEqAAAAAAACMA0GCSqGSIb3DQEBCwUA
// SIG // MIGIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylN
// SIG // aWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3Jp
// SIG // dHkgMjAxMDAeFw0xMDA3MDEyMTM2NTVaFw0yNTA3MDEy
// SIG // MTQ2NTVaMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNV
// SIG // BAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEw
// SIG // MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
// SIG // qR0NvHcRijog7PwTl/X6f2mUa3RUENWlCgCChfvtfGhL
// SIG // LF/Fw+Vhwna3PmYrW/AVUycEMR9BGxqVHc4JE458YTBZ
// SIG // sTBED/FgiIRUQwzXTbg4CLNC3ZOs1nMwVyaCo0UN0Or1
// SIG // R4HNvyRgMlhgRvJYR4YyhB50YWeRX4FUsc+TTJLBxKZd
// SIG // 0WETbijGGvmGgLvfYfxGwScdJGcSchohiq9LZIlQYrFd
// SIG // /XcfPfBXday9ikJNQFHRD5wGPmd/9WbAA5ZEfu/QS/1u
// SIG // 5ZrKsajyeioKMfDaTgaRtogINeh4HLDpmc085y9Euqf0
// SIG // 3GS9pAHBIAmTeM38vMDJRF1eFpwBBU8iTQIDAQABo4IB
// SIG // 5jCCAeIwEAYJKwYBBAGCNxUBBAMCAQAwHQYDVR0OBBYE
// SIG // FNVjOlyKMZDzQ3t8RhvFM2hahW1VMBkGCSsGAQQBgjcU
// SIG // AgQMHgoAUwB1AGIAQwBBMAsGA1UdDwQEAwIBhjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFNX2VsuP6KJc
// SIG // YmjRPZSQW9fOmhjEMFYGA1UdHwRPME0wS6BJoEeGRWh0
// SIG // dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3By
// SIG // b2R1Y3RzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNy
// SIG // bDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKGPmh0
// SIG // dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMv
// SIG // TWljUm9vQ2VyQXV0XzIwMTAtMDYtMjMuY3J0MIGgBgNV
// SIG // HSABAf8EgZUwgZIwgY8GCSsGAQQBgjcuAzCBgTA9Bggr
// SIG // BgEFBQcCARYxaHR0cDovL3d3dy5taWNyb3NvZnQuY29t
// SIG // L1BLSS9kb2NzL0NQUy9kZWZhdWx0Lmh0bTBABggrBgEF
// SIG // BQcCAjA0HjIgHQBMAGUAZwBhAGwAXwBQAG8AbABpAGMA
// SIG // eQBfAFMAdABhAHQAZQBtAGUAbgB0AC4gHTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAgEAB+aIUQ3ixuCYP4FxAz2do6Ehb7Pr
// SIG // psz1Mb7PBeKp/vpXbRkws8LFZslq3/Xn8Hi9x6ieJeP5
// SIG // vO1rVFcIK1GCRBL7uVOMzPRgEop2zEBAQZvcXBf/XPle
// SIG // FzWYJFZLdO9CEMivv3/Gf/I3fVo/HPKZeUqRUgCvOA8X
// SIG // 9S95gWXZqbVr5MfO9sp6AG9LMEQkIjzP7QOllo9ZKby2
// SIG // /QThcJ8ySif9Va8v/rbljjO7Yl+a21dA6fHOmWaQjP9q
// SIG // Yn/dxUoLkSbiOewZSnFjnXshbcOco6I8+n99lmqQeKZt
// SIG // 0uGc+R38ONiU9MalCpaGpL2eGq4EQoO4tYCbIjggtSXl
// SIG // ZOz39L9+Y1klD3ouOVd2onGqBooPiRa6YacRy5rYDkea
// SIG // gMXQzafQ732D8OE7cQnfXXSYIghh2rBQHm+98eEA3+cx
// SIG // B6STOvdlR3jo+KhIq/fecn5ha293qYHLpwmsObvsxsvY
// SIG // grRyzR30uIUBHoD7G4kqVDmyW9rIDVWZeodzOwjmmC3q
// SIG // jeAzLhIp9cAvVCch98isTtoouLGp25ayp0Kiyc8ZQU3g
// SIG // hvkqmqMRZjDTu3QyS99je/WZii8bxyGvWbWu3EQ8l1Bx
// SIG // 16HSxVXjad5XwdHeMMD9zOZN+w2/XU/pnR4ZOC+8z1gF
// SIG // Lu8NoFA12u8JJxzVs341Hgi62jbb01+P3nSISRIwggTa
// SIG // MIIDwqADAgECAhMzAAAAo+8fIiCBY9ylAAAAAACjMA0G
// SIG // CSqGSIb3DQEBCwUAMHwxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // JjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBD
// SIG // QSAyMDEwMB4XDTE2MDkwNzE3NTY0OVoXDTE4MDkwNzE3
// SIG // NTY0OVowgbMxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNV
// SIG // BAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIgRFNFIEVT
// SIG // TjpDMEY0LTMwODYtREVGODElMCMGA1UEAxMcTWljcm9z
// SIG // b2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBAKnRHpfHE2n4ODsV
// SIG // F+ZIDvlfgqxUnTAarRBd0PIF9z9ohjda0ABT5pxtHGjy
// SIG // KcfW/zGYUk0RuvXBZIY6OQknVklen6EhGSkbzFoW4/N9
// SIG // AVUXLOnhrJb7x5mvKHAAdSL6LnKUVF+60cWsMtTl1h55
// SIG // 8IGjCr5jvnhpZ+KPhdHJvsh/kIvkuH6Yrm++KmQIGki3
// SIG // OSHIavQkS2AQ1HKAcgg46W75O1PtWdsk1E1hyFvTaWMA
// SIG // Mr3MsVE960C4f7i+u3IdwThs3gmObi2ZOmxFCN6zT1tt
// SIG // bYCR2SObSJlMHuURf7MXnnaRveImFh8RABw635noLP/s
// SIG // dSxYKXCnFy0o7o+0o18CAwEAAaOCARswggEXMB0GA1Ud
// SIG // DgQWBBT6hbpmZuhGmdpwn7ohJUDb4OixcDAfBgNVHSME
// SIG // GDAWgBTVYzpcijGQ80N7fEYbxTNoWoVtVTBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNUaW1TdGFQQ0Ff
// SIG // MjAxMC0wNy0wMS5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY1RpbVN0YVBDQV8yMDEwLTA3
// SIG // LTAxLmNydDAMBgNVHRMBAf8EAjAAMBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMIMA0GCSqGSIb3DQEBCwUAA4IBAQAd0UW6
// SIG // W7S/iuaGjUXONYgmEkawM4NqYTHIFnP45iR6asHAFTc8
// SIG // jccpDUjLdJelsofhBnjVQ4xTOvDiUQ54ttP8HI0l5VMa
// SIG // Fdk+erzHu8FOZlhRGA9lJWEhob7mkcNgjvkJtD6IwqZy
// SIG // gTsc8hAc1QWuiF00VVKoQ4aM8A1UvkvkS+4XlbabvAJr
// SIG // Fs2yLWz1q9814QaDtFlB5x4B82hN99jeJCxGS0LAjRdz
// SIG // RFArjd52zX90Xd/mZMwyuJ7Az2VSEQgGepe2g2WjYtjD
// SIG // g7o5jke4U6rDZhocvUlO9NzUB6zSuNFk+eB3yex2gMSr
// SIG // FyvrI4O1lonx2EuWkt1vqcI71vOcoYIDeTCCAmECAQEw
// SIG // geOhgbmkgbYwgbMxCzAJBgNVBAYTAlVTMRMwEQYDVQQI
// SIG // EwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4w
// SIG // HAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xDTAL
// SIG // BgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIgRFNF
// SIG // IEVTTjpDMEY0LTMwODYtREVGODElMCMGA1UEAxMcTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZaIlCgEBMAkG
// SIG // BSsOAwIaBQADFQA15KP7Tj//Jg1x9W1eEnuRljimjaCB
// SIG // wjCBv6SBvDCBuTELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsG
// SIG // A1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBOVFMg
// SIG // RVNOOjU3RjYtQzFFMC01NTRDMSswKQYDVQQDEyJNaWNy
// SIG // b3NvZnQgVGltZSBTb3VyY2UgTWFzdGVyIENsb2NrMA0G
// SIG // CSqGSIb3DQEBBQUAAgUA3EYpuzAiGA8yMDE3MDIwODIz
// SIG // MzUyM1oYDzIwMTcwMjA5MjMzNTIzWjB3MD0GCisGAQQB
// SIG // hFkKBAExLzAtMAoCBQDcRim7AgEAMAoCAQACAgXMAgH/
// SIG // MAcCAQACAhetMAoCBQDcR3s7AgEAMDYGCisGAQQBhFkK
// SIG // BAIxKDAmMAwGCisGAQQBhFkKAwGgCjAIAgEAAgMW42Ch
// SIG // CjAIAgEAAgMHoSAwDQYJKoZIhvcNAQEFBQADggEBADsI
// SIG // VkTO6ENv1qlX31knRF0bYWWwpiIyDsw5/I8L+B2A5N7d
// SIG // aKrtHEohDWwOF8FUOX8ps6auFtQCP7lqs8bWcZKokjIj
// SIG // 1rhSWrXBZJng/yR3rSfiV8dNK+/KbTiuGFMuY3YYeNjF
// SIG // M6TIfJOHILlqbeIZfBaCYmDAf8ebO/KSSbhHs8orZm5h
// SIG // NxB2fr65tFY6t4zk7brdCYh8vpjtEA9dIEtpMPCfQsku
// SIG // hOyquDYnyKe8RADo0m1Xin/Z5ga/GY7kYhx86pbnVMIw
// SIG // Z4pol6SszCXi7WgFK9YAivx521f7NQbaw3S/J0VaTWaX
// SIG // p8+yteuCdRvnlXWsHa0SKGnev9pLnsYxggL1MIIC8QIB
// SIG // ATCBkzB8MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQD
// SIG // Ex1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMAIT
// SIG // MwAAAKPvHyIggWPcpQAAAAAAozANBglghkgBZQMEAgEF
// SIG // AKCCATIwGgYJKoZIhvcNAQkDMQ0GCyqGSIb3DQEJEAEE
// SIG // MC8GCSqGSIb3DQEJBDEiBCB0Yk103x2UXQQWwdTYgHbn
// SIG // YTQIHeaEIcRih1yXsaF8bDCB4gYLKoZIhvcNAQkQAgwx
// SIG // gdIwgc8wgcwwgbEEFDXko/tOP/8mDXH1bV4Se5GWOKaN
// SIG // MIGYMIGApH4wfDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQG
// SIG // A1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIw
// SIG // MTACEzMAAACj7x8iIIFj3KUAAAAAAKMwFgQUNBpzKvPP
// SIG // SWjQZQZUjzVW2JtD170wDQYJKoZIhvcNAQELBQAEggEA
// SIG // UUWPGVUovv0E4QLqcC4Aik6jPpKjifd1bojDAttKElYW
// SIG // IuD55ZF7TX+Uwnvrrx925t8GVsnvcnSlvEcpsvLNYGmm
// SIG // Bw17xwQdTJwQPb31nXnojFunhkthA3xQ3kxnAtZKVYEK
// SIG // Y7fm3xpE8AGtLnC+1GieOGyjeRuE82iwIM/UJYDrXLCp
// SIG // RZNHM7B6UHqP8FlN0eW53gOgKC2O+lEbNRqTKOfrvc2R
// SIG // X1dGYeTT0jTpu6qHCYm958ZvvGSS23KNHKar5/NDGKWJ
// SIG // pGafN7XuzP5UQ77kXx1ki50mTkNVG/LKyf9ezDjy/oGE
// SIG // M25O1Xf4s4bTar8DrfqqkOC2rslQMI/rdA==
// SIG // End signature block
